!function(e,t){"function"==typeof define&&define.amd?define([],t):"object"==typeof module&&module.exports?module.exports=t():e.htmx=e.htmx||t()}("undefined"!=typeof self?self:this,(function(){return function(){"use strict";var htmx={onLoad:onLoadHelper,process:processNode,on:addEventListenerImpl,off:removeEventListenerImpl,trigger:triggerEvent,ajax:ajaxHelper,find:find,findAll:findAll,closest:closest,values:function(e,t){return getInputValues(e,t||"post").values},remove:removeElement,addClass:addClassToElement,removeClass:removeClassFromElement,toggleClass:toggleClassOnElement,takeClass:takeClassForElement,defineExtension:defineExtension,removeExtension:removeExtension,logAll:logAll,logNone:logNone,logger:null,config:{historyEnabled:!0,historyCacheSize:10,refreshOnHistoryMiss:!1,defaultSwapStyle:"innerHTML",defaultSwapDelay:0,defaultSettleDelay:20,includeIndicatorStyles:!0,indicatorClass:"htmx-indicator",requestClass:"htmx-request",addedClass:"htmx-added",settlingClass:"htmx-settling",swappingClass:"htmx-swapping",allowEval:!0,allowScriptTags:!0,inlineScriptNonce:"",attributesToSettle:["class","style","width","height"],withCredentials:!1,timeout:0,wsReconnectDelay:"full-jitter",wsBinaryType:"blob",disableSelector:"[hx-disable], [data-hx-disable]",useTemplateFragments:!1,scrollBehavior:"smooth",defaultFocusScroll:!1,getCacheBusterParam:!1,globalViewTransitions:!1,methodsThatUseUrlParams:["get"],selfRequestsOnly:!1,ignoreTitle:!1,scrollIntoViewOnBoost:!0,triggerSpecsCache:null},parseInterval:parseInterval,_:internalEval,createEventSource:function(e){return new EventSource(e,{withCredentials:!0})},createWebSocket:function(e){var t=new WebSocket(e,[]);return t.binaryType=htmx.config.wsBinaryType,t},version:"1.9.10"},internalAPI={addTriggerHandler:addTriggerHandler,bodyContains:bodyContains,canAccessLocalStorage:canAccessLocalStorage,findThisElement:findThisElement,filterValues:filterValues,hasAttribute:hasAttribute,getAttributeValue:getAttributeValue,getClosestAttributeValue:getClosestAttributeValue,getClosestMatch:getClosestMatch,getExpressionVars:getExpressionVars,getHeaders:getHeaders,getInputValues:getInputValues,getInternalData:getInternalData,getSwapSpecification:getSwapSpecification,getTriggerSpecs:getTriggerSpecs,getTarget:getTarget,makeFragment:makeFragment,mergeObjects:mergeObjects,makeSettleInfo:makeSettleInfo,oobSwap:oobSwap,querySelectorExt:querySelectorExt,selectAndSwap:selectAndSwap,settleImmediately:settleImmediately,shouldCancel:shouldCancel,triggerEvent:triggerEvent,triggerErrorEvent:triggerErrorEvent,withExtensions:withExtensions},VERBS=["get","post","put","delete","patch"],VERB_SELECTOR=VERBS.map((function(e){return"[hx-"+e+"], [data-hx-"+e+"]"})).join(", "),HEAD_TAG_REGEX=makeTagRegEx("head"),TITLE_TAG_REGEX=makeTagRegEx("title"),SVG_TAGS_REGEX=makeTagRegEx("svg",!0);function makeTagRegEx(e,t=!1){return new RegExp(`<${e}(\\s[^>]*>|>)([\\s\\S]*?)<\\/${e}>`,t?"gim":"im")}function parseInterval(e){if(null==e)return;let t=NaN;return t="ms"==e.slice(-2)?parseFloat(e.slice(0,-2)):"s"==e.slice(-1)?1e3*parseFloat(e.slice(0,-1)):"m"==e.slice(-1)?1e3*parseFloat(e.slice(0,-1))*60:parseFloat(e),isNaN(t)?void 0:t}function getRawAttribute(e,t){return e.getAttribute&&e.getAttribute(t)}function hasAttribute(e,t){return e.hasAttribute&&(e.hasAttribute(t)||e.hasAttribute("data-"+t))}function getAttributeValue(e,t){return getRawAttribute(e,t)||getRawAttribute(e,"data-"+t)}function parentElt(e){return e.parentElement}function getDocument(){return document}function getClosestMatch(e,t){for(;e&&!t(e);)e=parentElt(e);return e||null}function getAttributeValueWithDisinheritance(e,t,r){var n=getAttributeValue(t,r),a=getAttributeValue(t,"hx-disinherit");return e!==t&&a&&("*"===a||a.split(" ").indexOf(r)>=0)?"unset":n}function getClosestAttributeValue(e,t){var r=null;if(getClosestMatch(e,(function(n){return r=getAttributeValueWithDisinheritance(e,n,t)})),"unset"!==r)return r}function matches(e,t){var r=e.matches||e.matchesSelector||e.msMatchesSelector||e.mozMatchesSelector||e.webkitMatchesSelector||e.oMatchesSelector;return r&&r.call(e,t)}function getStartTag(e){var t=/<([a-z][^\/\0>\x20\t\r\n\f]*)/i.exec(e);return t?t[1].toLowerCase():""}function parseHTML(e,t){for(var r=(new DOMParser).parseFromString(e,"text/html").body;t>0;)t--,r=r.firstChild;return null==r&&(r=getDocument().createDocumentFragment()),r}function aFullPageResponse(e){return/<body/.test(e)}function makeFragment(e){var t=!aFullPageResponse(e),r=getStartTag(e),n=e;if("head"===r&&(n=n.replace(HEAD_TAG_REGEX,"")),htmx.config.useTemplateFragments&&t)return parseHTML("<body><template>"+n+"</template></body>",0).querySelector("template").content;switch(r){case"thead":case"tbody":case"tfoot":case"colgroup":case"caption":return parseHTML("<table>"+n+"</table>",1);case"col":return parseHTML("<table><colgroup>"+n+"</colgroup></table>",2);case"tr":return parseHTML("<table><tbody>"+n+"</tbody></table>",2);case"td":case"th":return parseHTML("<table><tbody><tr>"+n+"</tr></tbody></table>",3);case"script":case"style":return parseHTML("<div>"+n+"</div>",1);default:return parseHTML(n,0)}}function maybeCall(e){e&&e()}function isType(e,t){return Object.prototype.toString.call(e)==="[object "+t+"]"}function isFunction(e){return isType(e,"Function")}function isRawObject(e){return isType(e,"Object")}function getInternalData(e){var t="htmx-internal-data",r=e[t];return r||(r=e[t]={}),r}function toArray(e){var t=[];if(e)for(var r=0;r<e.length;r++)t.push(e[r]);return t}function forEach(e,t){if(e)for(var r=0;r<e.length;r++)t(e[r])}function isScrolledIntoView(e){var t=e.getBoundingClientRect(),r=t.top,n=t.bottom;return r<window.innerHeight&&n>=0}function bodyContains(e){return e.getRootNode&&e.getRootNode()instanceof window.ShadowRoot?getDocument().body.contains(e.getRootNode().host):getDocument().body.contains(e)}function splitOnWhitespace(e){return e.trim().split(/\s+/)}function mergeObjects(e,t){for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r]);return e}function parseJSON(e){try{return JSON.parse(e)}catch(e){return logError(e),null}}function canAccessLocalStorage(){var e="htmx:localStorageTest";try{return localStorage.setItem(e,e),localStorage.removeItem(e),!0}catch(e){return!1}}function normalizePath(e){try{var t=new URL(e);return t&&(e=t.pathname+t.search),/^\/$/.test(e)||(e=e.replace(/\/+$/,"")),e}catch(t){return e}}function internalEval(str){return maybeEval(getDocument().body,(function(){return eval(str)}))}function onLoadHelper(e){return htmx.on("htmx:load",(function(t){e(t.detail.elt)}))}function logAll(){htmx.logger=function(e,t,r){console&&console.log(t,e,r)}}function logNone(){htmx.logger=null}function find(e,t){return t?e.querySelector(t):find(getDocument(),e)}function findAll(e,t){return t?e.querySelectorAll(t):findAll(getDocument(),e)}function removeElement(e,t){e=resolveTarget(e),t?setTimeout((function(){removeElement(e),e=null}),t):e.parentElement.removeChild(e)}function addClassToElement(e,t,r){e=resolveTarget(e),r?setTimeout((function(){addClassToElement(e,t),e=null}),r):e.classList&&e.classList.add(t)}function removeClassFromElement(e,t,r){e=resolveTarget(e),r?setTimeout((function(){removeClassFromElement(e,t),e=null}),r):e.classList&&(e.classList.remove(t),0===e.classList.length&&e.removeAttribute("class"))}function toggleClassOnElement(e,t){(e=resolveTarget(e)).classList.toggle(t)}function takeClassForElement(e,t){forEach((e=resolveTarget(e)).parentElement.children,(function(e){removeClassFromElement(e,t)})),addClassToElement(e,t)}function closest(e,t){if((e=resolveTarget(e)).closest)return e.closest(t);do{if(null==e||matches(e,t))return e}while(e=e&&parentElt(e));return null}function startsWith(e,t){return e.substring(0,t.length)===t}function endsWith(e,t){return e.substring(e.length-t.length)===t}function normalizeSelector(e){var t=e.trim();return startsWith(t,"<")&&endsWith(t,"/>")?t.substring(1,t.length-2):t}function querySelectorAllExt(e,t){return 0===t.indexOf("closest ")?[closest(e,normalizeSelector(t.substr(8)))]:0===t.indexOf("find ")?[find(e,normalizeSelector(t.substr(5)))]:"next"===t?[e.nextElementSibling]:0===t.indexOf("next ")?[scanForwardQuery(e,normalizeSelector(t.substr(5)))]:"previous"===t?[e.previousElementSibling]:0===t.indexOf("previous ")?[scanBackwardsQuery(e,normalizeSelector(t.substr(9)))]:"document"===t?[document]:"window"===t?[window]:"body"===t?[document.body]:getDocument().querySelectorAll(normalizeSelector(t))}var scanForwardQuery=function(e,t){for(var r=getDocument().querySelectorAll(t),n=0;n<r.length;n++){var a=r[n];if(a.compareDocumentPosition(e)===Node.DOCUMENT_POSITION_PRECEDING)return a}},scanBackwardsQuery=function(e,t){for(var r=getDocument().querySelectorAll(t),n=r.length-1;n>=0;n--){var a=r[n];if(a.compareDocumentPosition(e)===Node.DOCUMENT_POSITION_FOLLOWING)return a}};function querySelectorExt(e,t){return t?querySelectorAllExt(e,t)[0]:querySelectorAllExt(getDocument().body,e)[0]}function resolveTarget(e){return isType(e,"String")?find(e):e}function processEventArgs(e,t,r){return isFunction(t)?{target:getDocument().body,event:e,listener:t}:{target:resolveTarget(e),event:t,listener:r}}function addEventListenerImpl(e,t,r){return ready((function(){var n=processEventArgs(e,t,r);n.target.addEventListener(n.event,n.listener)})),isFunction(t)?t:r}function removeEventListenerImpl(e,t,r){return ready((function(){var n=processEventArgs(e,t,r);n.target.removeEventListener(n.event,n.listener)})),isFunction(t)?t:r}var DUMMY_ELT=getDocument().createElement("output");function findAttributeTargets(e,t){var r=getClosestAttributeValue(e,t);if(r){if("this"===r)return[findThisElement(e,t)];var n=querySelectorAllExt(e,r);return 0===n.length?(logError('The selector "'+r+'" on '+t+" returned no matches!"),[DUMMY_ELT]):n}}function findThisElement(e,t){return getClosestMatch(e,(function(e){return null!=getAttributeValue(e,t)}))}function getTarget(e){var t=getClosestAttributeValue(e,"hx-target");return t?"this"===t?findThisElement(e,"hx-target"):querySelectorExt(e,t):getInternalData(e).boosted?getDocument().body:e}function shouldSettleAttribute(e){for(var t=htmx.config.attributesToSettle,r=0;r<t.length;r++)if(e===t[r])return!0;return!1}function cloneAttributes(e,t){forEach(e.attributes,(function(r){!t.hasAttribute(r.name)&&shouldSettleAttribute(r.name)&&e.removeAttribute(r.name)})),forEach(t.attributes,(function(t){shouldSettleAttribute(t.name)&&e.setAttribute(t.name,t.value)}))}function isInlineSwap(e,t){for(var r=getExtensions(t),n=0;n<r.length;n++){var a=r[n];try{if(a.isInlineSwap(e))return!0}catch(e){logError(e)}}return"outerHTML"===e}function oobSwap(e,t,r){var n="#"+getRawAttribute(t,"id"),a="outerHTML";"true"===e||(e.indexOf(":")>0?(a=e.substr(0,e.indexOf(":")),n=e.substr(e.indexOf(":")+1,e.length)):a=e);var o=getDocument().querySelectorAll(n);return o?(forEach(o,(function(e){var n,o=t.cloneNode(!0);(n=getDocument().createDocumentFragment()).appendChild(o),isInlineSwap(a,e)||(n=o);var i={shouldSwap:!0,target:e,fragment:n};triggerEvent(e,"htmx:oobBeforeSwap",i)&&(e=i.target,i.shouldSwap&&swap(a,e,e,n,r),forEach(r.elts,(function(e){triggerEvent(e,"htmx:oobAfterSwap",i)})))})),t.parentNode.removeChild(t)):(t.parentNode.removeChild(t),triggerErrorEvent(getDocument().body,"htmx:oobErrorNoTarget",{content:t})),e}function handleOutOfBandSwaps(e,t,r){var n=getClosestAttributeValue(e,"hx-select-oob");if(n)for(var a=n.split(","),o=0;o<a.length;o++){var i=a[o].split(":",2),s=i[0].trim();0===s.indexOf("#")&&(s=s.substring(1));var l=i[1]||"true",u=t.querySelector("#"+s);u&&oobSwap(l,u,r)}forEach(findAll(t,"[hx-swap-oob], [data-hx-swap-oob]"),(function(e){var t=getAttributeValue(e,"hx-swap-oob");null!=t&&oobSwap(t,e,r)}))}function handlePreservedElements(e){forEach(findAll(e,"[hx-preserve], [data-hx-preserve]"),(function(e){var t=getAttributeValue(e,"id"),r=getDocument().getElementById(t);null!=r&&e.parentNode.replaceChild(r,e)}))}function handleAttributes(e,t,r){forEach(t.querySelectorAll("[id]"),(function(t){var n=getRawAttribute(t,"id");if(n&&n.length>0){var a=n.replace("'","\\'"),o=t.tagName.replace(":","\\:"),i=e.querySelector(o+"[id='"+a+"']");if(i&&i!==e){var s=t.cloneNode();cloneAttributes(t,i),r.tasks.push((function(){cloneAttributes(t,s)}))}}}))}function makeAjaxLoadTask(e){return function(){removeClassFromElement(e,htmx.config.addedClass),processNode(e),processScripts(e),processFocus(e),triggerEvent(e,"htmx:load")}}function processFocus(e){var t="[autofocus]",r=matches(e,t)?e:e.querySelector(t);null!=r&&r.focus()}function insertNodesBefore(e,t,r,n){for(handleAttributes(e,r,n);r.childNodes.length>0;){var a=r.firstChild;addClassToElement(a,htmx.config.addedClass),e.insertBefore(a,t),a.nodeType!==Node.TEXT_NODE&&a.nodeType!==Node.COMMENT_NODE&&n.tasks.push(makeAjaxLoadTask(a))}}function stringHash(e,t){for(var r=0;r<e.length;)t=(t<<5)-t+e.charCodeAt(r++)|0;return t}function attributeHash(e){var t=0;if(e.attributes)for(var r=0;r<e.attributes.length;r++){var n=e.attributes[r];n.value&&(t=stringHash(n.name,t),t=stringHash(n.value,t))}return t}function deInitOnHandlers(e){var t=getInternalData(e);if(t.onHandlers){for(var r=0;r<t.onHandlers.length;r++){const n=t.onHandlers[r];e.removeEventListener(n.event,n.listener)}delete t.onHandlers}}function deInitNode(e){var t=getInternalData(e);t.timeout&&clearTimeout(t.timeout),t.webSocket&&t.webSocket.close(),t.sseEventSource&&t.sseEventSource.close(),t.listenerInfos&&forEach(t.listenerInfos,(function(e){e.on&&e.on.removeEventListener(e.trigger,e.listener)})),deInitOnHandlers(e),forEach(Object.keys(t),(function(e){delete t[e]}))}function cleanUpElement(e){triggerEvent(e,"htmx:beforeCleanupElement"),deInitNode(e),e.children&&forEach(e.children,(function(e){cleanUpElement(e)}))}function swapOuterHTML(e,t,r){if("BODY"===e.tagName)return swapInnerHTML(e,t,r);var n,a=e.previousSibling;for(insertNodesBefore(parentElt(e),e,t,r),n=null==a?parentElt(e).firstChild:a.nextSibling,r.elts=r.elts.filter((function(t){return t!=e}));n&&n!==e;)n.nodeType===Node.ELEMENT_NODE&&r.elts.push(n),n=n.nextElementSibling;cleanUpElement(e),parentElt(e).removeChild(e)}function swapAfterBegin(e,t,r){return insertNodesBefore(e,e.firstChild,t,r)}function swapBeforeBegin(e,t,r){return insertNodesBefore(parentElt(e),e,t,r)}function swapBeforeEnd(e,t,r){return insertNodesBefore(e,null,t,r)}function swapAfterEnd(e,t,r){return insertNodesBefore(parentElt(e),e.nextSibling,t,r)}function swapDelete(e,t,r){return cleanUpElement(e),parentElt(e).removeChild(e)}function swapInnerHTML(e,t,r){var n=e.firstChild;if(insertNodesBefore(e,n,t,r),n){for(;n.nextSibling;)cleanUpElement(n.nextSibling),e.removeChild(n.nextSibling);cleanUpElement(n),e.removeChild(n)}}function maybeSelectFromResponse(e,t,r){var n=r||getClosestAttributeValue(e,"hx-select");if(n){var a=getDocument().createDocumentFragment();forEach(t.querySelectorAll(n),(function(e){a.appendChild(e)})),t=a}return t}function swap(e,t,r,n,a){switch(e){case"none":return;case"outerHTML":return void swapOuterHTML(r,n,a);case"afterbegin":return void swapAfterBegin(r,n,a);case"beforebegin":return void swapBeforeBegin(r,n,a);case"beforeend":return void swapBeforeEnd(r,n,a);case"afterend":return void swapAfterEnd(r,n,a);case"delete":return void swapDelete(r,n,a);default:for(var o=getExtensions(t),i=0;i<o.length;i++){var s=o[i];try{var l=s.handleSwap(e,r,n,a);if(l){if(void 0!==l.length)for(var u=0;u<l.length;u++){var c=l[u];c.nodeType!==Node.TEXT_NODE&&c.nodeType!==Node.COMMENT_NODE&&a.tasks.push(makeAjaxLoadTask(c))}return}}catch(e){logError(e)}}"innerHTML"===e?swapInnerHTML(r,n,a):swap(htmx.config.defaultSwapStyle,t,r,n,a)}}function findTitle(e){if(e.indexOf("<title")>-1){var t=e.replace(SVG_TAGS_REGEX,"").match(TITLE_TAG_REGEX);if(t)return t[2]}}function selectAndSwap(e,t,r,n,a,o){a.title=findTitle(n);var i=makeFragment(n);if(i)return handleOutOfBandSwaps(r,i,a),handlePreservedElements(i=maybeSelectFromResponse(r,i,o)),swap(e,r,t,i,a)}function handleTrigger(e,t,r){var n=e.getResponseHeader(t);if(0===n.indexOf("{")){var a=parseJSON(n);for(var o in a)if(a.hasOwnProperty(o)){var i=a[o];isRawObject(i)||(i={value:i}),triggerEvent(r,o,i)}}else for(var s=n.split(","),l=0;l<s.length;l++)triggerEvent(r,s[l].trim(),[])}var WHITESPACE=/\s/,WHITESPACE_OR_COMMA=/[\s,]/,SYMBOL_START=/[_$a-zA-Z]/,SYMBOL_CONT=/[_$a-zA-Z0-9]/,STRINGISH_START=['"',"'","/"],NOT_WHITESPACE=/[^\s]/,COMBINED_SELECTOR_START=/[{(]/,COMBINED_SELECTOR_END=/[})]/;function tokenizeString(e){for(var t=[],r=0;r<e.length;){if(SYMBOL_START.exec(e.charAt(r))){for(var n=r;SYMBOL_CONT.exec(e.charAt(r+1));)r++;t.push(e.substr(n,r-n+1))}else if(-1!==STRINGISH_START.indexOf(e.charAt(r))){var a=e.charAt(r);for(n=r,r++;r<e.length&&e.charAt(r)!==a;)"\\"===e.charAt(r)&&r++,r++;t.push(e.substr(n,r-n+1))}else{var o=e.charAt(r);t.push(o)}r++}return t}function isPossibleRelativeReference(e,t,r){return SYMBOL_START.exec(e.charAt(0))&&"true"!==e&&"false"!==e&&"this"!==e&&e!==r&&"."!==t}function maybeGenerateConditional(e,t,r){if("["===t[0]){t.shift();for(var n=1,a=" return (function("+r+"){ return (",o=null;t.length>0;){var i=t[0];if("]"===i){if(0==--n){null===o&&(a+="true"),t.shift(),a+=")})";try{var s=maybeEval(e,(function(){return Function(a)()}),(function(){return!0}));return s.source=a,s}catch(e){return triggerErrorEvent(getDocument().body,"htmx:syntax:error",{error:e,source:a}),null}}}else"["===i&&n++;isPossibleRelativeReference(i,o,r)?a+="(("+r+"."+i+") ? ("+r+"."+i+") : (window."+i+"))":a+=i,o=t.shift()}}}function consumeUntil(e,t){for(var r="";e.length>0&&!t.test(e[0]);)r+=e.shift();return r}function consumeCSSSelector(e){var t;return e.length>0&&COMBINED_SELECTOR_START.test(e[0])?(e.shift(),t=consumeUntil(e,COMBINED_SELECTOR_END).trim(),e.shift()):t=consumeUntil(e,WHITESPACE_OR_COMMA),t}var INPUT_SELECTOR="input, textarea, select";function parseAndCacheTrigger(e,t,r){var n=[],a=tokenizeString(t);do{consumeUntil(a,NOT_WHITESPACE);var o=a.length,i=consumeUntil(a,/[,\[\s]/);if(""!==i)if("every"===i){var s={trigger:"every"};consumeUntil(a,NOT_WHITESPACE),s.pollInterval=parseInterval(consumeUntil(a,/[,\[\s]/)),consumeUntil(a,NOT_WHITESPACE),(l=maybeGenerateConditional(e,a,"event"))&&(s.eventFilter=l),n.push(s)}else if(0===i.indexOf("sse:"))n.push({trigger:"sse",sseEvent:i.substr(4)});else{var l,u={trigger:i};for((l=maybeGenerateConditional(e,a,"event"))&&(u.eventFilter=l);a.length>0&&","!==a[0];){consumeUntil(a,NOT_WHITESPACE);var c=a.shift();if("changed"===c)u.changed=!0;else if("once"===c)u.once=!0;else if("consume"===c)u.consume=!0;else if("delay"===c&&":"===a[0])a.shift(),u.delay=parseInterval(consumeUntil(a,WHITESPACE_OR_COMMA));else if("from"===c&&":"===a[0]){if(a.shift(),COMBINED_SELECTOR_START.test(a[0]))var g=consumeCSSSelector(a);else if("closest"===(g=consumeUntil(a,WHITESPACE_OR_COMMA))||"find"===g||"next"===g||"previous"===g){a.shift();var f=consumeCSSSelector(a);f.length>0&&(g+=" "+f)}u.from=g}else"target"===c&&":"===a[0]?(a.shift(),u.target=consumeCSSSelector(a)):"throttle"===c&&":"===a[0]?(a.shift(),u.throttle=parseInterval(consumeUntil(a,WHITESPACE_OR_COMMA))):"queue"===c&&":"===a[0]?(a.shift(),u.queue=consumeUntil(a,WHITESPACE_OR_COMMA)):"root"===c&&":"===a[0]?(a.shift(),u[c]=consumeCSSSelector(a)):"threshold"===c&&":"===a[0]?(a.shift(),u[c]=consumeUntil(a,WHITESPACE_OR_COMMA)):triggerErrorEvent(e,"htmx:syntax:error",{token:a.shift()})}n.push(u)}a.length===o&&triggerErrorEvent(e,"htmx:syntax:error",{token:a.shift()}),consumeUntil(a,NOT_WHITESPACE)}while(","===a[0]&&a.shift());return r&&(r[t]=n),n}function getTriggerSpecs(e){var t=getAttributeValue(e,"hx-trigger"),r=[];if(t){var n=htmx.config.triggerSpecsCache;r=n&&n[t]||parseAndCacheTrigger(e,t,n)}return r.length>0?r:matches(e,"form")?[{trigger:"submit"}]:matches(e,'input[type="button"], input[type="submit"]')?[{trigger:"click"}]:matches(e,INPUT_SELECTOR)?[{trigger:"change"}]:[{trigger:"click"}]}function cancelPolling(e){getInternalData(e).cancelled=!0}function processPolling(e,t,r){var n=getInternalData(e);n.timeout=setTimeout((function(){bodyContains(e)&&!0!==n.cancelled&&(maybeFilterEvent(r,e,makeEvent("hx:poll:trigger",{triggerSpec:r,target:e}))||t(e),processPolling(e,t,r))}),r.pollInterval)}function isLocalLink(e){return location.hostname===e.hostname&&getRawAttribute(e,"href")&&0!==getRawAttribute(e,"href").indexOf("#")}function boostElement(e,t,r){if("A"===e.tagName&&isLocalLink(e)&&(""===e.target||"_self"===e.target)||"FORM"===e.tagName){var n,a;if(t.boosted=!0,"A"===e.tagName)n="get",a=getRawAttribute(e,"href");else{var o=getRawAttribute(e,"method");n=o?o.toLowerCase():"get",a=getRawAttribute(e,"action")}r.forEach((function(r){addEventListener(e,(function(e,t){closest(e,htmx.config.disableSelector)?cleanUpElement(e):issueAjaxRequest(n,a,e,t)}),t,r,!0)}))}}function shouldCancel(e,t){if("submit"===e.type||"click"===e.type){if("FORM"===t.tagName)return!0;if(matches(t,'input[type="submit"], button')&&null!==closest(t,"form"))return!0;if("A"===t.tagName&&t.href&&("#"===t.getAttribute("href")||0!==t.getAttribute("href").indexOf("#")))return!0}return!1}function ignoreBoostedAnchorCtrlClick(e,t){return getInternalData(e).boosted&&"A"===e.tagName&&"click"===t.type&&(t.ctrlKey||t.metaKey)}function maybeFilterEvent(e,t,r){var n=e.eventFilter;if(n)try{return!0!==n.call(t,r)}catch(e){return triggerErrorEvent(getDocument().body,"htmx:eventFilter:error",{error:e,source:n.source}),!0}return!1}function addEventListener(e,t,r,n,a){var o,i=getInternalData(e);o=n.from?querySelectorAllExt(e,n.from):[e],n.changed&&o.forEach((function(e){getInternalData(e).lastValue=e.value})),forEach(o,(function(o){var s=function(r){if(bodyContains(e)){if(!ignoreBoostedAnchorCtrlClick(e,r)&&((a||shouldCancel(r,e))&&r.preventDefault(),!maybeFilterEvent(n,e,r))){var l=getInternalData(r);if(l.triggerSpec=n,null==l.handledFor&&(l.handledFor=[]),l.handledFor.indexOf(e)<0){if(l.handledFor.push(e),n.consume&&r.stopPropagation(),n.target&&r.target&&!matches(r.target,n.target))return;if(n.once){if(i.triggeredOnce)return;i.triggeredOnce=!0}if(n.changed){var u=getInternalData(o);if(u.lastValue===o.value)return;u.lastValue=o.value}if(i.delayed&&clearTimeout(i.delayed),i.throttle)return;n.throttle>0?i.throttle||(t(e,r),i.throttle=setTimeout((function(){i.throttle=null}),n.throttle)):n.delay>0?i.delayed=setTimeout((function(){t(e,r)}),n.delay):(triggerEvent(e,"htmx:trigger"),t(e,r))}}}else o.removeEventListener(n.trigger,s)};null==r.listenerInfos&&(r.listenerInfos=[]),r.listenerInfos.push({trigger:n.trigger,listener:s,on:o}),o.addEventListener(n.trigger,s)}))}var windowIsScrolling=!1,scrollHandler=null;function initScrollHandler(){scrollHandler||(scrollHandler=function(){windowIsScrolling=!0},window.addEventListener("scroll",scrollHandler),setInterval((function(){windowIsScrolling&&(windowIsScrolling=!1,forEach(getDocument().querySelectorAll("[hx-trigger='revealed'],[data-hx-trigger='revealed']"),(function(e){maybeReveal(e)})))}),200))}function maybeReveal(e){!hasAttribute(e,"data-hx-revealed")&&isScrolledIntoView(e)&&(e.setAttribute("data-hx-revealed","true"),getInternalData(e).initHash?triggerEvent(e,"revealed"):e.addEventListener("htmx:afterProcessNode",(function(t){triggerEvent(e,"revealed")}),{once:!0}))}function processWebSocketInfo(e,t,r){for(var n=splitOnWhitespace(r),a=0;a<n.length;a++){var o=n[a].split(/:(.+)/);"connect"===o[0]&&ensureWebSocket(e,o[1],0),"send"===o[0]&&processWebSocketSend(e)}}function ensureWebSocket(e,t,r){if(bodyContains(e)){if(0==t.indexOf("/")){var n=location.hostname+(location.port?":"+location.port:"");"https:"==location.protocol?t="wss://"+n+t:"http:"==location.protocol&&(t="ws://"+n+t)}var a=htmx.createWebSocket(t);a.onerror=function(t){triggerErrorEvent(e,"htmx:wsError",{error:t,socket:a}),maybeCloseWebSocketSource(e)},a.onclose=function(n){if([1006,1012,1013].indexOf(n.code)>=0){var a=getWebSocketReconnectDelay(r);setTimeout((function(){ensureWebSocket(e,t,r+1)}),a)}},a.onopen=function(e){r=0},getInternalData(e).webSocket=a,a.addEventListener("message",(function(t){if(!maybeCloseWebSocketSource(e)){var r=t.data;withExtensions(e,(function(t){r=t.transformResponse(r,null,e)}));for(var n=makeSettleInfo(e),a=toArray(makeFragment(r).children),o=0;o<a.length;o++){var i=a[o];oobSwap(getAttributeValue(i,"hx-swap-oob")||"true",i,n)}settleImmediately(n.tasks)}}))}}function maybeCloseWebSocketSource(e){if(!bodyContains(e))return getInternalData(e).webSocket.close(),!0}function processWebSocketSend(e){var t=getClosestMatch(e,(function(e){return null!=getInternalData(e).webSocket}));t?e.addEventListener(getTriggerSpecs(e)[0].trigger,(function(r){var n=getInternalData(t).webSocket,a=getHeaders(e,t),o=getInputValues(e,"post"),i=o.errors,s=filterValues(mergeObjects(o.values,getExpressionVars(e)),e);s.HEADERS=a,i&&i.length>0?triggerEvent(e,"htmx:validation:halted",i):(n.send(JSON.stringify(s)),shouldCancel(r,e)&&r.preventDefault())})):triggerErrorEvent(e,"htmx:noWebSocketSourceError")}function getWebSocketReconnectDelay(e){var t=htmx.config.wsReconnectDelay;if("function"==typeof t)return t(e);if("full-jitter"===t){var r=Math.min(e,6);return 1e3*Math.pow(2,r)*Math.random()}logError('htmx.config.wsReconnectDelay must either be a function or the string "full-jitter"')}function processSSEInfo(e,t,r){for(var n=splitOnWhitespace(r),a=0;a<n.length;a++){var o=n[a].split(/:(.+)/);"connect"===o[0]&&processSSESource(e,o[1]),"swap"===o[0]&&processSSESwap(e,o[1])}}function processSSESource(e,t){var r=htmx.createEventSource(t);r.onerror=function(t){triggerErrorEvent(e,"htmx:sseError",{error:t,source:r}),maybeCloseSSESource(e)},getInternalData(e).sseEventSource=r}function processSSESwap(e,t){var r=getClosestMatch(e,hasEventSource);if(r){var n=getInternalData(r).sseEventSource,a=function(o){if(!maybeCloseSSESource(r))if(bodyContains(e)){var i=o.data;withExtensions(e,(function(t){i=t.transformResponse(i,null,e)}));var s=getSwapSpecification(e),l=getTarget(e),u=makeSettleInfo(e);selectAndSwap(s.swapStyle,l,e,i,u),settleImmediately(u.tasks),triggerEvent(e,"htmx:sseMessage",o)}else n.removeEventListener(t,a)};getInternalData(e).sseListener=a,n.addEventListener(t,a)}else triggerErrorEvent(e,"htmx:noSSESourceError")}function processSSETrigger(e,t,r){var n=getClosestMatch(e,hasEventSource);if(n){var a=getInternalData(n).sseEventSource,o=function(){maybeCloseSSESource(n)||(bodyContains(e)?t(e):a.removeEventListener(r,o))};getInternalData(e).sseListener=o,a.addEventListener(r,o)}else triggerErrorEvent(e,"htmx:noSSESourceError")}function maybeCloseSSESource(e){if(!bodyContains(e))return getInternalData(e).sseEventSource.close(),!0}function hasEventSource(e){return null!=getInternalData(e).sseEventSource}function loadImmediately(e,t,r,n){var a=function(){r.loaded||(r.loaded=!0,t(e))};n>0?setTimeout(a,n):a()}function processVerbs(e,t,r){var n=!1;return forEach(VERBS,(function(a){if(hasAttribute(e,"hx-"+a)){var o=getAttributeValue(e,"hx-"+a);n=!0,t.path=o,t.verb=a,r.forEach((function(r){addTriggerHandler(e,r,t,(function(e,t){closest(e,htmx.config.disableSelector)?cleanUpElement(e):issueAjaxRequest(a,o,e,t)}))}))}})),n}function addTriggerHandler(e,t,r,n){if(t.sseEvent)processSSETrigger(e,n,t.sseEvent);else if("revealed"===t.trigger)initScrollHandler(),addEventListener(e,n,r,t),maybeReveal(e);else if("intersect"===t.trigger){var a={};t.root&&(a.root=querySelectorExt(e,t.root)),t.threshold&&(a.threshold=parseFloat(t.threshold)),new IntersectionObserver((function(t){for(var r=0;r<t.length;r++)if(t[r].isIntersecting){triggerEvent(e,"intersect");break}}),a).observe(e),addEventListener(e,n,r,t)}else"load"===t.trigger?maybeFilterEvent(t,e,makeEvent("load",{elt:e}))||loadImmediately(e,n,r,t.delay):t.pollInterval>0?(r.polling=!0,processPolling(e,n,t)):addEventListener(e,n,r,t)}function evalScript(e){if(htmx.config.allowScriptTags&&("text/javascript"===e.type||"module"===e.type||""===e.type)){var t=getDocument().createElement("script");forEach(e.attributes,(function(e){t.setAttribute(e.name,e.value)})),t.textContent=e.textContent,t.async=!1,htmx.config.inlineScriptNonce&&(t.nonce=htmx.config.inlineScriptNonce);var r=e.parentElement;try{r.insertBefore(t,e)}catch(e){logError(e)}finally{e.parentElement&&e.parentElement.removeChild(e)}}}function processScripts(e){matches(e,"script")&&evalScript(e),forEach(findAll(e,"script"),(function(e){evalScript(e)}))}function shouldProcessHxOn(e){for(var t=e.attributes,r=0;r<t.length;r++){var n=t[r].name;if(startsWith(n,"hx-on:")||startsWith(n,"data-hx-on:")||startsWith(n,"hx-on-")||startsWith(n,"data-hx-on-"))return!0}return!1}function findHxOnWildcardElements(e){var t=null,r=[];if(shouldProcessHxOn(e)&&r.push(e),document.evaluate)for(var n=document.evaluate('.//*[@*[ starts-with(name(), "hx-on:") or starts-with(name(), "data-hx-on:") or starts-with(name(), "hx-on-") or starts-with(name(), "data-hx-on-") ]]',e);t=n.iterateNext();)r.push(t);else for(var a=e.getElementsByTagName("*"),o=0;o<a.length;o++)shouldProcessHxOn(a[o])&&r.push(a[o]);return r}function findElementsToProcess(e){return e.querySelectorAll?e.querySelectorAll(VERB_SELECTOR+", [hx-boost] a, [data-hx-boost] a, a[hx-boost], a[data-hx-boost], form, [type='submit'], [hx-sse], [data-hx-sse], [hx-ws], [data-hx-ws], [hx-ext], [data-hx-ext], [hx-trigger], [data-hx-trigger], [hx-on], [data-hx-on]"):[]}function maybeSetLastButtonClicked(e){var t=closest(e.target,"button, input[type='submit']"),r=getRelatedFormData(e);r&&(r.lastButtonClicked=t)}function maybeUnsetLastButtonClicked(e){var t=getRelatedFormData(e);t&&(t.lastButtonClicked=null)}function getRelatedFormData(e){var t=closest(e.target,"button, input[type='submit']");if(t){var r=resolveTarget("#"+getRawAttribute(t,"form"))||closest(t,"form");if(r)return getInternalData(r)}}function initButtonTracking(e){e.addEventListener("click",maybeSetLastButtonClicked),e.addEventListener("focusin",maybeSetLastButtonClicked),e.addEventListener("focusout",maybeUnsetLastButtonClicked)}function countCurlies(e){for(var t=tokenizeString(e),r=0,n=0;n<t.length;n++){const e=t[n];"{"===e?r++:"}"===e&&r--}return r}function addHxOnEventHandler(e,t,r){var n,a=getInternalData(e);Array.isArray(a.onHandlers)||(a.onHandlers=[]);var o=function(t){return maybeEval(e,(function(){n||(n=new Function("event",r)),n.call(e,t)}))};e.addEventListener(t,o),a.onHandlers.push({event:t,listener:o})}function processHxOn(e){var t=getAttributeValue(e,"hx-on");if(t){for(var r={},n=t.split("\n"),a=null,o=0;n.length>0;){var i=n.shift(),s=i.match(/^\s*([a-zA-Z:\-\.]+:)(.*)/);0===o&&s?(i.split(":"),r[a=s[1].slice(0,-1)]=s[2]):r[a]+=i,o+=countCurlies(i)}for(var l in r)addHxOnEventHandler(e,l,r[l])}}function processHxOnWildcard(e){deInitOnHandlers(e);for(var t=0;t<e.attributes.length;t++){var r=e.attributes[t].name,n=e.attributes[t].value;if(startsWith(r,"hx-on")||startsWith(r,"data-hx-on")){var a=r.indexOf("-on")+3,o=r.slice(a,a+1);if("-"===o||":"===o){var i=r.slice(a+1);startsWith(i,":")?i="htmx"+i:startsWith(i,"-")?i="htmx:"+i.slice(1):startsWith(i,"htmx-")&&(i="htmx:"+i.slice(5)),addHxOnEventHandler(e,i,n)}}}}function initNode(e){if(closest(e,htmx.config.disableSelector))cleanUpElement(e);else{var t=getInternalData(e);if(t.initHash!==attributeHash(e)){deInitNode(e),t.initHash=attributeHash(e),processHxOn(e),triggerEvent(e,"htmx:beforeProcessNode"),e.value&&(t.lastValue=e.value);var r=getTriggerSpecs(e);processVerbs(e,t,r)||("true"===getClosestAttributeValue(e,"hx-boost")?boostElement(e,t,r):hasAttribute(e,"hx-trigger")&&r.forEach((function(r){addTriggerHandler(e,r,t,(function(){}))}))),("FORM"===e.tagName||"submit"===getRawAttribute(e,"type")&&hasAttribute(e,"form"))&&initButtonTracking(e);var n=getAttributeValue(e,"hx-sse");n&&processSSEInfo(e,t,n);var a=getAttributeValue(e,"hx-ws");a&&processWebSocketInfo(e,t,a),triggerEvent(e,"htmx:afterProcessNode")}}}function processNode(e){closest(e=resolveTarget(e),htmx.config.disableSelector)?cleanUpElement(e):(initNode(e),forEach(findElementsToProcess(e),(function(e){initNode(e)})),forEach(findHxOnWildcardElements(e),processHxOnWildcard))}function kebabEventName(e){return e.replace(/([a-z0-9])([A-Z])/g,"$1-$2").toLowerCase()}function makeEvent(e,t){var r;return window.CustomEvent&&"function"==typeof window.CustomEvent?r=new CustomEvent(e,{bubbles:!0,cancelable:!0,detail:t}):(r=getDocument().createEvent("CustomEvent")).initCustomEvent(e,!0,!0,t),r}function triggerErrorEvent(e,t,r){triggerEvent(e,t,mergeObjects({error:t},r))}function ignoreEventForLogging(e){return"htmx:afterProcessNode"===e}function withExtensions(e,t){forEach(getExtensions(e),(function(e){try{t(e)}catch(e){logError(e)}}))}function logError(e){console.error?console.error(e):console.log&&console.log("ERROR: ",e)}function triggerEvent(e,t,r){e=resolveTarget(e),null==r&&(r={}),r.elt=e;var n=makeEvent(t,r);htmx.logger&&!ignoreEventForLogging(t)&&htmx.logger(e,t,r),r.error&&(logError(r.error),triggerEvent(e,"htmx:error",{errorInfo:r}));var a=e.dispatchEvent(n),o=kebabEventName(t);if(a&&o!==t){var i=makeEvent(o,n.detail);a=a&&e.dispatchEvent(i)}return withExtensions(e,(function(e){a=a&&!1!==e.onEvent(t,n)&&!n.defaultPrevented})),a}var currentPathForHistory=location.pathname+location.search;function getHistoryElement(){return getDocument().querySelector("[hx-history-elt],[data-hx-history-elt]")||getDocument().body}function saveToHistoryCache(e,t,r,n){if(canAccessLocalStorage())if(htmx.config.historyCacheSize<=0)localStorage.removeItem("htmx-history-cache");else{e=normalizePath(e);for(var a=parseJSON(localStorage.getItem("htmx-history-cache"))||[],o=0;o<a.length;o++)if(a[o].url===e){a.splice(o,1);break}var i={url:e,content:t,title:r,scroll:n};for(triggerEvent(getDocument().body,"htmx:historyItemCreated",{item:i,cache:a}),a.push(i);a.length>htmx.config.historyCacheSize;)a.shift();for(;a.length>0;)try{localStorage.setItem("htmx-history-cache",JSON.stringify(a));break}catch(e){triggerErrorEvent(getDocument().body,"htmx:historyCacheError",{cause:e,cache:a}),a.shift()}}}function getCachedHistory(e){if(!canAccessLocalStorage())return null;e=normalizePath(e);for(var t=parseJSON(localStorage.getItem("htmx-history-cache"))||[],r=0;r<t.length;r++)if(t[r].url===e)return t[r];return null}function cleanInnerHtmlForHistory(e){var t=htmx.config.requestClass,r=e.cloneNode(!0);return forEach(findAll(r,"."+t),(function(e){removeClassFromElement(e,t)})),r.innerHTML}function saveCurrentPageToHistory(){var e,t=getHistoryElement(),r=currentPathForHistory||location.pathname+location.search;try{e=getDocument().querySelector('[hx-history="false" i],[data-hx-history="false" i]')}catch(t){e=getDocument().querySelector('[hx-history="false"],[data-hx-history="false"]')}e||(triggerEvent(getDocument().body,"htmx:beforeHistorySave",{path:r,historyElt:t}),saveToHistoryCache(r,cleanInnerHtmlForHistory(t),getDocument().title,window.scrollY)),htmx.config.historyEnabled&&history.replaceState({htmx:!0},getDocument().title,window.location.href)}function pushUrlIntoHistory(e){htmx.config.getCacheBusterParam&&(endsWith(e=e.replace(/org\.htmx\.cache-buster=[^&]*&?/,""),"&")||endsWith(e,"?"))&&(e=e.slice(0,-1)),htmx.config.historyEnabled&&history.pushState({htmx:!0},"",e),currentPathForHistory=e}function replaceUrlInHistory(e){htmx.config.historyEnabled&&history.replaceState({htmx:!0},"",e),currentPathForHistory=e}function settleImmediately(e){forEach(e,(function(e){e.call()}))}function loadHistoryFromServer(e){var t=new XMLHttpRequest,r={path:e,xhr:t};triggerEvent(getDocument().body,"htmx:historyCacheMiss",r),t.open("GET",e,!0),t.setRequestHeader("HX-Request","true"),t.setRequestHeader("HX-History-Restore-Request","true"),t.setRequestHeader("HX-Current-URL",getDocument().location.href),t.onload=function(){if(this.status>=200&&this.status<400){triggerEvent(getDocument().body,"htmx:historyCacheMissLoad",r);var t=makeFragment(this.response);t=t.querySelector("[hx-history-elt],[data-hx-history-elt]")||t;var n=getHistoryElement(),a=makeSettleInfo(n),o=findTitle(this.response);if(o){var i=find("title");i?i.innerHTML=o:window.document.title=o}swapInnerHTML(n,t,a),settleImmediately(a.tasks),currentPathForHistory=e,triggerEvent(getDocument().body,"htmx:historyRestore",{path:e,cacheMiss:!0,serverResponse:this.response})}else triggerErrorEvent(getDocument().body,"htmx:historyCacheMissLoadError",r)},t.send()}function restoreHistory(e){saveCurrentPageToHistory();var t=getCachedHistory(e=e||location.pathname+location.search);if(t){var r=makeFragment(t.content),n=getHistoryElement(),a=makeSettleInfo(n);swapInnerHTML(n,r,a),settleImmediately(a.tasks),document.title=t.title,setTimeout((function(){window.scrollTo(0,t.scroll)}),0),currentPathForHistory=e,triggerEvent(getDocument().body,"htmx:historyRestore",{path:e,item:t})}else htmx.config.refreshOnHistoryMiss?window.location.reload(!0):loadHistoryFromServer(e)}function addRequestIndicatorClasses(e){var t=findAttributeTargets(e,"hx-indicator");return null==t&&(t=[e]),forEach(t,(function(e){var t=getInternalData(e);t.requestCount=(t.requestCount||0)+1,e.classList.add.call(e.classList,htmx.config.requestClass)})),t}function disableElements(e){var t=findAttributeTargets(e,"hx-disabled-elt");return null==t&&(t=[]),forEach(t,(function(e){var t=getInternalData(e);t.requestCount=(t.requestCount||0)+1,e.setAttribute("disabled","")})),t}function removeRequestIndicators(e,t){forEach(e,(function(e){var t=getInternalData(e);t.requestCount=(t.requestCount||0)-1,0===t.requestCount&&e.classList.remove.call(e.classList,htmx.config.requestClass)})),forEach(t,(function(e){var t=getInternalData(e);t.requestCount=(t.requestCount||0)-1,0===t.requestCount&&e.removeAttribute("disabled")}))}function haveSeenNode(e,t){for(var r=0;r<e.length;r++)if(e[r].isSameNode(t))return!0;return!1}function shouldInclude(e){return""!==e.name&&null!=e.name&&!e.disabled&&!closest(e,"fieldset[disabled]")&&"button"!==e.type&&"submit"!==e.type&&"image"!==e.tagName&&"reset"!==e.tagName&&"file"!==e.tagName&&("checkbox"!==e.type&&"radio"!==e.type||e.checked)}function addValueToValues(e,t,r){if(null!=e&&null!=t){var n=r[e];void 0===n?r[e]=t:Array.isArray(n)?Array.isArray(t)?r[e]=n.concat(t):n.push(t):Array.isArray(t)?r[e]=[n].concat(t):r[e]=[n,t]}}function processInputValue(e,t,r,n,a){if(null!=n&&!haveSeenNode(e,n)){if(e.push(n),shouldInclude(n)){var o=getRawAttribute(n,"name"),i=n.value;n.multiple&&"SELECT"===n.tagName&&(i=toArray(n.querySelectorAll("option:checked")).map((function(e){return e.value}))),n.files&&(i=toArray(n.files)),addValueToValues(o,i,t),a&&validateElement(n,r)}matches(n,"form")&&forEach(n.elements,(function(n){processInputValue(e,t,r,n,a)}))}}function validateElement(e,t){e.willValidate&&(triggerEvent(e,"htmx:validation:validate"),e.checkValidity()||(t.push({elt:e,message:e.validationMessage,validity:e.validity}),triggerEvent(e,"htmx:validation:failed",{message:e.validationMessage,validity:e.validity})))}function getInputValues(e,t){var r=[],n={},a={},o=[],i=getInternalData(e);i.lastButtonClicked&&!bodyContains(i.lastButtonClicked)&&(i.lastButtonClicked=null);var s=matches(e,"form")&&!0!==e.noValidate||"true"===getAttributeValue(e,"hx-validate");if(i.lastButtonClicked&&(s=s&&!0!==i.lastButtonClicked.formNoValidate),"get"!==t&&processInputValue(r,a,o,closest(e,"form"),s),processInputValue(r,n,o,e,s),i.lastButtonClicked||"BUTTON"===e.tagName||"INPUT"===e.tagName&&"submit"===getRawAttribute(e,"type")){var l=i.lastButtonClicked||e;addValueToValues(getRawAttribute(l,"name"),l.value,a)}return forEach(findAttributeTargets(e,"hx-include"),(function(e){processInputValue(r,n,o,e,s),matches(e,"form")||forEach(e.querySelectorAll(INPUT_SELECTOR),(function(e){processInputValue(r,n,o,e,s)}))})),n=mergeObjects(n,a),{errors:o,values:n}}function appendParam(e,t,r){""!==e&&(e+="&"),"[object Object]"===String(r)&&(r=JSON.stringify(r));var n=encodeURIComponent(r);return e+(encodeURIComponent(t)+"=")+n}function urlEncode(e){var t="";for(var r in e)if(e.hasOwnProperty(r)){var n=e[r];Array.isArray(n)?forEach(n,(function(e){t=appendParam(t,r,e)})):t=appendParam(t,r,n)}return t}function makeFormData(e){var t=new FormData;for(var r in e)if(e.hasOwnProperty(r)){var n=e[r];Array.isArray(n)?forEach(n,(function(e){t.append(r,e)})):t.append(r,n)}return t}function getHeaders(e,t,r){var n={"HX-Request":"true","HX-Trigger":getRawAttribute(e,"id"),"HX-Trigger-Name":getRawAttribute(e,"name"),"HX-Target":getAttributeValue(t,"id"),"HX-Current-URL":getDocument().location.href};return getValuesForElement(e,"hx-headers",!1,n),void 0!==r&&(n["HX-Prompt"]=r),getInternalData(e).boosted&&(n["HX-Boosted"]="true"),n}function filterValues(e,t){var r=getClosestAttributeValue(t,"hx-params");if(r){if("none"===r)return{};if("*"===r)return e;if(0===r.indexOf("not "))return forEach(r.substr(4).split(","),(function(t){t=t.trim(),delete e[t]})),e;var n={};return forEach(r.split(","),(function(t){t=t.trim(),n[t]=e[t]})),n}return e}function isAnchorLink(e){return getRawAttribute(e,"href")&&getRawAttribute(e,"href").indexOf("#")>=0}function getSwapSpecification(e,t){var r=t||getClosestAttributeValue(e,"hx-swap"),n={swapStyle:getInternalData(e).boosted?"innerHTML":htmx.config.defaultSwapStyle,swapDelay:htmx.config.defaultSwapDelay,settleDelay:htmx.config.defaultSettleDelay};if(htmx.config.scrollIntoViewOnBoost&&getInternalData(e).boosted&&!isAnchorLink(e)&&(n.show="top"),r){var a=splitOnWhitespace(r);if(a.length>0)for(var o=0;o<a.length;o++){var i=a[o];if(0===i.indexOf("swap:"))n.swapDelay=parseInterval(i.substr(5));else if(0===i.indexOf("settle:"))n.settleDelay=parseInterval(i.substr(7));else if(0===i.indexOf("transition:"))n.transition="true"===i.substr(11);else if(0===i.indexOf("ignoreTitle:"))n.ignoreTitle="true"===i.substr(12);else if(0===i.indexOf("scroll:")){var s=(u=i.substr(7).split(":")).pop(),l=u.length>0?u.join(":"):null;n.scroll=s,n.scrollTarget=l}else if(0===i.indexOf("show:")){var u,c=(u=i.substr(5).split(":")).pop();l=u.length>0?u.join(":"):null,n.show=c,n.showTarget=l}else if(0===i.indexOf("focus-scroll:")){var g=i.substr(13);n.focusScroll="true"==g}else 0==o?n.swapStyle=i:logError("Unknown modifier in hx-swap: "+i)}}return n}function usesFormData(e){return"multipart/form-data"===getClosestAttributeValue(e,"hx-encoding")||matches(e,"form")&&"multipart/form-data"===getRawAttribute(e,"enctype")}function encodeParamsForBody(e,t,r){var n=null;return withExtensions(t,(function(a){null==n&&(n=a.encodeParameters(e,r,t))})),null!=n?n:usesFormData(t)?makeFormData(r):urlEncode(r)}function makeSettleInfo(e){return{tasks:[],elts:[e]}}function updateScrollState(e,t){var r=e[0],n=e[e.length-1];if(t.scroll){var a=null;t.scrollTarget&&(a=querySelectorExt(r,t.scrollTarget)),"top"===t.scroll&&(r||a)&&((a=a||r).scrollTop=0),"bottom"===t.scroll&&(n||a)&&((a=a||n).scrollTop=a.scrollHeight)}if(t.show){if(a=null,t.showTarget){var o=t.showTarget;"window"===t.showTarget&&(o="body"),a=querySelectorExt(r,o)}"top"===t.show&&(r||a)&&(a=a||r).scrollIntoView({block:"start",behavior:htmx.config.scrollBehavior}),"bottom"===t.show&&(n||a)&&(a=a||n).scrollIntoView({block:"end",behavior:htmx.config.scrollBehavior})}}function getValuesForElement(e,t,r,n){if(null==n&&(n={}),null==e)return n;var a=getAttributeValue(e,t);if(a){var o,i=a.trim(),s=r;if("unset"===i)return null;for(var l in 0===i.indexOf("javascript:")?(i=i.substr(11),s=!0):0===i.indexOf("js:")&&(i=i.substr(3),s=!0),0!==i.indexOf("{")&&(i="{"+i+"}"),o=s?maybeEval(e,(function(){return Function("return ("+i+")")()}),{}):parseJSON(i))o.hasOwnProperty(l)&&null==n[l]&&(n[l]=o[l])}return getValuesForElement(parentElt(e),t,r,n)}function maybeEval(e,t,r){return htmx.config.allowEval?t():(triggerErrorEvent(e,"htmx:evalDisallowedError"),r)}function getHXVarsForElement(e,t){return getValuesForElement(e,"hx-vars",!0,t)}function getHXValsForElement(e,t){return getValuesForElement(e,"hx-vals",!1,t)}function getExpressionVars(e){return mergeObjects(getHXVarsForElement(e),getHXValsForElement(e))}function safelySetHeaderValue(e,t,r){if(null!==r)try{e.setRequestHeader(t,r)}catch(n){e.setRequestHeader(t,encodeURIComponent(r)),e.setRequestHeader(t+"-URI-AutoEncoded","true")}}function getPathFromResponse(e){if(e.responseURL&&"undefined"!=typeof URL)try{var t=new URL(e.responseURL);return t.pathname+t.search}catch(t){triggerErrorEvent(getDocument().body,"htmx:badResponseUrl",{url:e.responseURL})}}function hasHeader(e,t){return t.test(e.getAllResponseHeaders())}function ajaxHelper(e,t,r){return e=e.toLowerCase(),r?r instanceof Element||isType(r,"String")?issueAjaxRequest(e,t,null,null,{targetOverride:resolveTarget(r),returnPromise:!0}):issueAjaxRequest(e,t,resolveTarget(r.source),r.event,{handler:r.handler,headers:r.headers,values:r.values,targetOverride:resolveTarget(r.target),swapOverride:r.swap,select:r.select,returnPromise:!0}):issueAjaxRequest(e,t,null,null,{returnPromise:!0})}function hierarchyForElt(e){for(var t=[];e;)t.push(e),e=e.parentElement;return t}function verifyPath(e,t,r){var n,a;return"function"==typeof URL?(a=new URL(t,document.location.href),n=document.location.origin===a.origin):(a=t,n=startsWith(t,document.location.origin)),!(htmx.config.selfRequestsOnly&&!n)&&triggerEvent(e,"htmx:validateUrl",mergeObjects({url:a,sameHost:n},r))}function issueAjaxRequest(e,t,r,n,a,o){var i=null,s=null;if((a=null!=a?a:{}).returnPromise&&"undefined"!=typeof Promise)var l=new Promise((function(e,t){i=e,s=t}));null==r&&(r=getDocument().body);var u=a.handler||handleAjaxResponse,c=a.select||null;if(!bodyContains(r))return maybeCall(i),l;var g=a.targetOverride||getTarget(r);if(null==g||g==DUMMY_ELT)return triggerErrorEvent(r,"htmx:targetError",{target:getAttributeValue(r,"hx-target")}),maybeCall(s),l;var f=getInternalData(r),d=f.lastButtonClicked;if(d){var h=getRawAttribute(d,"formaction");null!=h&&(t=h);var m=getRawAttribute(d,"formmethod");null!=m&&"dialog"!==m.toLowerCase()&&(e=m)}var v=getClosestAttributeValue(r,"hx-confirm");if(void 0===o&&!1===triggerEvent(r,"htmx:confirm",{target:g,elt:r,path:t,verb:e,triggeringEvent:n,etc:a,issueRequest:function(o){return issueAjaxRequest(e,t,r,n,a,!!o)},question:v}))return maybeCall(i),l;var p=r,E=getClosestAttributeValue(r,"hx-sync"),b=null,x=!1;if(E){var y=E.split(":"),S=y[0].trim();if(p="this"===S?findThisElement(r,"hx-sync"):querySelectorExt(r,S),E=(y[1]||"drop").trim(),f=getInternalData(p),"drop"===E&&f.xhr&&!0!==f.abortable)return maybeCall(i),l;if("abort"===E){if(f.xhr)return maybeCall(i),l;x=!0}else"replace"===E?triggerEvent(p,"htmx:abort"):0===E.indexOf("queue")&&(b=(E.split(" ")[1]||"last").trim())}if(f.xhr){if(!f.abortable){if(null==b){if(n){var C=getInternalData(n);C&&C.triggerSpec&&C.triggerSpec.queue&&(b=C.triggerSpec.queue)}null==b&&(b="last")}return null==f.queuedRequests&&(f.queuedRequests=[]),"first"===b&&0===f.queuedRequests.length||"all"===b?f.queuedRequests.push((function(){issueAjaxRequest(e,t,r,n,a)})):"last"===b&&(f.queuedRequests=[],f.queuedRequests.push((function(){issueAjaxRequest(e,t,r,n,a)}))),maybeCall(i),l}triggerEvent(p,"htmx:abort")}var w=new XMLHttpRequest;f.xhr=w,f.abortable=x;var T=function(){f.xhr=null,f.abortable=!1,null!=f.queuedRequests&&f.queuedRequests.length>0&&f.queuedRequests.shift()()},A=getClosestAttributeValue(r,"hx-prompt");if(A){var H=prompt(A);if(null===H||!triggerEvent(r,"htmx:prompt",{prompt:H,target:g}))return maybeCall(i),T(),l}if(v&&!o&&!confirm(v))return maybeCall(i),T(),l;var R=getHeaders(r,g,H);"get"===e||usesFormData(r)||(R["Content-Type"]="application/x-www-form-urlencoded"),a.headers&&(R=mergeObjects(R,a.headers));var I=getInputValues(r,e),O=I.errors,D=I.values;a.values&&(D=mergeObjects(D,a.values));var L=mergeObjects(D,getExpressionVars(r)),q=filterValues(L,r);htmx.config.getCacheBusterParam&&"get"===e&&(q["org.htmx.cache-buster"]=getRawAttribute(g,"id")||"true"),null!=t&&""!==t||(t=getDocument().location.href);var N=getValuesForElement(r,"hx-request"),k=getInternalData(r).boosted,P=htmx.config.methodsThatUseUrlParams.indexOf(e)>=0,V={boosted:k,useUrlParams:P,parameters:q,unfilteredParameters:L,headers:R,target:g,verb:e,errors:O,withCredentials:a.credentials||N.credentials||htmx.config.withCredentials,timeout:a.timeout||N.timeout||htmx.config.timeout,path:t,triggeringEvent:n};if(!triggerEvent(r,"htmx:configRequest",V))return maybeCall(i),T(),l;if(t=V.path,e=V.verb,R=V.headers,q=V.parameters,P=V.useUrlParams,(O=V.errors)&&O.length>0)return triggerEvent(r,"htmx:validation:halted",V),maybeCall(i),T(),l;var M=t.split("#"),F=M[0],B=M[1],U=t;if(P&&(U=F,0!==Object.keys(q).length&&(U.indexOf("?")<0?U+="?":U+="&",U+=urlEncode(q),B&&(U+="#"+B))),!verifyPath(r,U,V))return triggerErrorEvent(r,"htmx:invalidPath",V),maybeCall(s),l;if(w.open(e.toUpperCase(),U,!0),w.overrideMimeType("text/html"),w.withCredentials=V.withCredentials,w.timeout=V.timeout,N.noHeaders);else for(var _ in R)if(R.hasOwnProperty(_)){var j=R[_];safelySetHeaderValue(w,_,j)}var W={xhr:w,target:g,requestConfig:V,etc:a,boosted:k,select:c,pathInfo:{requestPath:t,finalRequestPath:U,anchor:B}};if(w.onload=function(){try{var e=hierarchyForElt(r);if(W.pathInfo.responsePath=getPathFromResponse(w),u(r,W),removeRequestIndicators(X,G),triggerEvent(r,"htmx:afterRequest",W),triggerEvent(r,"htmx:afterOnLoad",W),!bodyContains(r)){for(var t=null;e.length>0&&null==t;){var n=e.shift();bodyContains(n)&&(t=n)}t&&(triggerEvent(t,"htmx:afterRequest",W),triggerEvent(t,"htmx:afterOnLoad",W))}maybeCall(i),T()}catch(e){throw triggerErrorEvent(r,"htmx:onLoadError",mergeObjects({error:e},W)),e}},w.onerror=function(){removeRequestIndicators(X,G),triggerErrorEvent(r,"htmx:afterRequest",W),triggerErrorEvent(r,"htmx:sendError",W),maybeCall(s),T()},w.onabort=function(){removeRequestIndicators(X,G),triggerErrorEvent(r,"htmx:afterRequest",W),triggerErrorEvent(r,"htmx:sendAbort",W),maybeCall(s),T()},w.ontimeout=function(){removeRequestIndicators(X,G),triggerErrorEvent(r,"htmx:afterRequest",W),triggerErrorEvent(r,"htmx:timeout",W),maybeCall(s),T()},!triggerEvent(r,"htmx:beforeRequest",W))return maybeCall(i),T(),l;var X=addRequestIndicatorClasses(r),G=disableElements(r);forEach(["loadstart","loadend","progress","abort"],(function(e){forEach([w,w.upload],(function(t){t.addEventListener(e,(function(t){triggerEvent(r,"htmx:xhr:"+e,{lengthComputable:t.lengthComputable,loaded:t.loaded,total:t.total})}))}))})),triggerEvent(r,"htmx:beforeSend",W);var z=P?null:encodeParamsForBody(w,r,q);return w.send(z),l}function determineHistoryUpdates(e,t){var r=t.xhr,n=null,a=null;if(hasHeader(r,/HX-Push:/i)?(n=r.getResponseHeader("HX-Push"),a="push"):hasHeader(r,/HX-Push-Url:/i)?(n=r.getResponseHeader("HX-Push-Url"),a="push"):hasHeader(r,/HX-Replace-Url:/i)&&(n=r.getResponseHeader("HX-Replace-Url"),a="replace"),n)return"false"===n?{}:{type:a,path:n};var o=t.pathInfo.finalRequestPath,i=t.pathInfo.responsePath,s=getClosestAttributeValue(e,"hx-push-url"),l=getClosestAttributeValue(e,"hx-replace-url"),u=getInternalData(e).boosted,c=null,g=null;return s?(c="push",g=s):l?(c="replace",g=l):u&&(c="push",g=i||o),g?"false"===g?{}:("true"===g&&(g=i||o),t.pathInfo.anchor&&-1===g.indexOf("#")&&(g=g+"#"+t.pathInfo.anchor),{type:c,path:g}):{}}function handleAjaxResponse(e,t){var r=t.xhr,n=t.target,a=t.etc,o=(t.requestConfig,t.select);if(triggerEvent(e,"htmx:beforeOnLoad",t)){if(hasHeader(r,/HX-Trigger:/i)&&handleTrigger(r,"HX-Trigger",e),hasHeader(r,/HX-Location:/i)){saveCurrentPageToHistory();var i=r.getResponseHeader("HX-Location");return 0===i.indexOf("{")&&(h=parseJSON(i),i=h.path,delete h.path),void ajaxHelper("GET",i,h).then((function(){pushUrlIntoHistory(i)}))}var s=hasHeader(r,/HX-Refresh:/i)&&"true"===r.getResponseHeader("HX-Refresh");if(hasHeader(r,/HX-Redirect:/i))return location.href=r.getResponseHeader("HX-Redirect"),void(s&&location.reload());if(s)location.reload();else{hasHeader(r,/HX-Retarget:/i)&&("this"===r.getResponseHeader("HX-Retarget")?t.target=e:t.target=querySelectorExt(e,r.getResponseHeader("HX-Retarget")));var l=determineHistoryUpdates(e,t),u=r.status>=200&&r.status<400&&204!==r.status,c=r.response,g=r.status>=400,f=htmx.config.ignoreTitle,d=mergeObjects({shouldSwap:u,serverResponse:c,isError:g,ignoreTitle:f},t);if(triggerEvent(n,"htmx:beforeSwap",d)){if(n=d.target,c=d.serverResponse,g=d.isError,f=d.ignoreTitle,t.target=n,t.failed=g,t.successful=!g,d.shouldSwap){286===r.status&&cancelPolling(e),withExtensions(e,(function(t){c=t.transformResponse(c,r,e)})),l.type&&saveCurrentPageToHistory();var h,m=a.swapOverride;hasHeader(r,/HX-Reswap:/i)&&(m=r.getResponseHeader("HX-Reswap")),(h=getSwapSpecification(e,m)).hasOwnProperty("ignoreTitle")&&(f=h.ignoreTitle),n.classList.add(htmx.config.swappingClass);var v=null,p=null,E=function(){try{var a,i=document.activeElement,s={};try{s={elt:i,start:i?i.selectionStart:null,end:i?i.selectionEnd:null}}catch(e){}o&&(a=o),hasHeader(r,/HX-Reselect:/i)&&(a=r.getResponseHeader("HX-Reselect")),l.type&&(triggerEvent(getDocument().body,"htmx:beforeHistoryUpdate",mergeObjects({history:l},t)),"push"===l.type?(pushUrlIntoHistory(l.path),triggerEvent(getDocument().body,"htmx:pushedIntoHistory",{path:l.path})):(replaceUrlInHistory(l.path),triggerEvent(getDocument().body,"htmx:replacedInHistory",{path:l.path})));var u=makeSettleInfo(n);if(selectAndSwap(h.swapStyle,n,e,c,u,a),s.elt&&!bodyContains(s.elt)&&getRawAttribute(s.elt,"id")){var g=document.getElementById(getRawAttribute(s.elt,"id")),d={preventScroll:void 0!==h.focusScroll?!h.focusScroll:!htmx.config.defaultFocusScroll};if(g){if(s.start&&g.setSelectionRange)try{g.setSelectionRange(s.start,s.end)}catch(e){}g.focus(d)}}if(n.classList.remove(htmx.config.swappingClass),forEach(u.elts,(function(e){e.classList&&e.classList.add(htmx.config.settlingClass),triggerEvent(e,"htmx:afterSwap",t)})),hasHeader(r,/HX-Trigger-After-Swap:/i)){var m=e;bodyContains(e)||(m=getDocument().body),handleTrigger(r,"HX-Trigger-After-Swap",m)}var E=function(){if(forEach(u.tasks,(function(e){e.call()})),forEach(u.elts,(function(e){e.classList&&e.classList.remove(htmx.config.settlingClass),triggerEvent(e,"htmx:afterSettle",t)})),t.pathInfo.anchor){var n=getDocument().getElementById(t.pathInfo.anchor);n&&n.scrollIntoView({block:"start",behavior:"auto"})}if(u.title&&!f){var a=find("title");a?a.innerHTML=u.title:window.document.title=u.title}if(updateScrollState(u.elts,h),hasHeader(r,/HX-Trigger-After-Settle:/i)){var o=e;bodyContains(e)||(o=getDocument().body),handleTrigger(r,"HX-Trigger-After-Settle",o)}maybeCall(v)};h.settleDelay>0?setTimeout(E,h.settleDelay):E()}catch(r){throw triggerErrorEvent(e,"htmx:swapError",t),maybeCall(p),r}},b=htmx.config.globalViewTransitions;if(h.hasOwnProperty("transition")&&(b=h.transition),b&&triggerEvent(e,"htmx:beforeTransition",t)&&"undefined"!=typeof Promise&&document.startViewTransition){var x=new Promise((function(e,t){v=e,p=t})),y=E;E=function(){document.startViewTransition((function(){return y(),x}))}}h.swapDelay>0?setTimeout(E,h.swapDelay):E()}g&&triggerErrorEvent(e,"htmx:responseError",mergeObjects({error:"Response Status Error Code "+r.status+" from "+t.pathInfo.requestPath},t))}}}}var extensions={};function extensionBase(){return{init:function(e){return null},onEvent:function(e,t){return!0},transformResponse:function(e,t,r){return e},isInlineSwap:function(e){return!1},handleSwap:function(e,t,r,n){return!1},encodeParameters:function(e,t,r){return null}}}function defineExtension(e,t){t.init&&t.init(internalAPI),extensions[e]=mergeObjects(extensionBase(),t)}function removeExtension(e){delete extensions[e]}function getExtensions(e,t,r){if(null==e)return t;null==t&&(t=[]),null==r&&(r=[]);var n=getAttributeValue(e,"hx-ext");return n&&forEach(n.split(","),(function(e){if("ignore:"!=(e=e.replace(/ /g,"")).slice(0,7)){if(r.indexOf(e)<0){var n=extensions[e];n&&t.indexOf(n)<0&&t.push(n)}}else r.push(e.slice(7))})),getExtensions(parentElt(e),t,r)}var isReady=!1;function ready(e){isReady||"complete"===getDocument().readyState?e():getDocument().addEventListener("DOMContentLoaded",e)}function insertIndicatorStyles(){!1!==htmx.config.includeIndicatorStyles&&getDocument().head.insertAdjacentHTML("beforeend","<style>                      ."+htmx.config.indicatorClass+"{opacity:0}                      ."+htmx.config.requestClass+" ."+htmx.config.indicatorClass+"{opacity:1; transition: opacity 200ms ease-in;}                      ."+htmx.config.requestClass+"."+htmx.config.indicatorClass+"{opacity:1; transition: opacity 200ms ease-in;}                    </style>")}function getMetaConfig(){var e=getDocument().querySelector('meta[name="htmx-config"]');return e?parseJSON(e.content):null}function mergeMetaConfig(){var e=getMetaConfig();e&&(htmx.config=mergeObjects(htmx.config,e))}return getDocument().addEventListener("DOMContentLoaded",(function(){isReady=!0})),ready((function(){mergeMetaConfig(),insertIndicatorStyles();var e=getDocument().body;processNode(e);var t=getDocument().querySelectorAll("[hx-trigger='restored'],[data-hx-trigger='restored']");e.addEventListener("htmx:abort",(function(e){var t=getInternalData(e.target);t&&t.xhr&&t.xhr.abort()}));const r=window.onpopstate?window.onpopstate.bind(window):null;window.onpopstate=function(e){e.state&&e.state.htmx?(restoreHistory(),forEach(t,(function(e){triggerEvent(e,"htmx:restored",{document:getDocument(),triggerEvent:triggerEvent})}))):r&&r(e)},setTimeout((function(){triggerEvent(e,"htmx:load",{}),e=null}),0)})),htmx}()})),htmx.defineExtension("craft-cp",{onEvent:function(e,t){switch(e){case"htmx:configRequest":this.configureRequest(t);break;case"htmx:load":this.onLoad(t)}},configureRequest:function(e){Object.assign(e.detail.headers,Craft._actionHeaders())},transformResponse:function(e,t,r){const n=(new DOMParser).parseFromString(e,"text/html");if(n.body===document.body)return;const a=n.querySelectorAll("template.hx-head-html"),o=n.querySelectorAll("template.hx-body-html");for(let e=0;e<a.length;e++){const t=a[e].innerHTML;t&&Craft.appendHeadHtml(t)}for(let e=0;e<o.length;e++){const t=o[e].innerHTML;t&&Craft.appendBodyHtml(t)}return e},onLoad:function(e){Craft.initUiElements(e.detail.elt)}}),htmx.defineExtension("craft-condition",{onEvent:function(e,t){"htmx:configRequest"===e&&this.configureRequest(t)},configureRequest:function(e){let t=$(e.detail.target).children(".condition-main");t.length||(t=$(e.detail.target).closest(".condition-main"));const r=t.data("condition-config");if(r&&r.name){const t=e.detail.elt.getAttribute("hx-vals")||e.detail.elt.getAttribute("data-hx-vals"),n=t?Object.keys(JSON.parse(t)):[];e.detail.parameters=Object.fromEntries(Object.entries(e.detail.parameters).filter((([e])=>n.includes(e)||0===e.indexOf(r.name))))}e.detail.parameters.config=JSON.stringify(r||{})}}),"undefined"!=typeof Craft&&Object.assign(htmx.config,{indicatorClass:"spinner",requestClass:"loading"});